/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.NullContextException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.ssl.SSLException;

public class ClientUserContext
implements Serializable {
    private static ThreadLocal THREAD_LOCAL = new ThreadLocal();
    private static InheritableThreadLocal INHERITED_THREAD_LOCAL = new InheritableThreadLocal();
    private static ClientUserContext CLIENT_SIDE_SYSTEM_CONTEXT = null;
    private transient HMCSession _session;
    private transient ConnectionFactory _connectionFactory;
    private Date _creationDate = new Date();
    private Locale[] _locale = new Locale[]{Locale.getDefault()};
    private transient boolean _inheritable = false;
    private InetAddress _address;
    private TimeZone timeZone;

    public static ClientUserContext getSystemContext() throws UnknownHostException {
        if (CLIENT_SIDE_SYSTEM_CONTEXT == null) {
            CLIENT_SIDE_SYSTEM_CONTEXT = new ClientUserContext(CommonSystem.getCommonSystem().getManagerHost(), 9940);
        }
        return CLIENT_SIDE_SYSTEM_CONTEXT;
    }

    public static ClientUserContext getUserContext() throws NullContextException {
        ClientUserContext context = (ClientUserContext)THREAD_LOCAL.get();
        if (context == null) {
            context = (ClientUserContext)INHERITED_THREAD_LOCAL.get();
        }
        if (context == null) {
            throw new NullContextException();
        }
        return context;
    }

    public static Locale staticGetLocale() throws NullContextException {
        return ClientUserContext.getUserContext().getLocale();
    }

    public static Date staticGetCreationDate() throws NullContextException {
        return ClientUserContext.getUserContext().getCreationDate();
    }

    public static String staticGetUserName() throws NullContextException {
        return ClientUserContext.getUserContext().getUserName();
    }

    public static ContextId staticGetID() throws NullContextException, SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, IOException, InvalidPasswordException, HException {
        return ClientUserContext.getUserContext().getClientID();
    }

    public static boolean staticIsLocalContext() throws UnknownHostException, NullContextException {
        return ClientUserContext.getUserContext().isLocalContext();
    }

    public ClientUserContext(InetAddress mgrAddress, int mgrPort) {
        this._connectionFactory = new ConnectionFactory(mgrAddress, mgrPort);
        this.setAddress(mgrAddress);
    }

    public ClientUserContext(ConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setHMCSession(HMCSession session) {
        this._session = session;
    }

    public HMCSession getHMCSession() {
        return this._session;
    }

    public void attachToThread(boolean inheritable) {
        this._inheritable = inheritable;
        if (inheritable) {
            INHERITED_THREAD_LOCAL.set(this);
        } else {
            THREAD_LOCAL.set(this);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public String getUserName() {
        return this.getConnectionFactory().getUserName();
    }

    public InetAddress getServerAddress() {
        return this.getConnectionFactory().getServerAddress();
    }

    public int getServerPort() {
        return this.getConnectionFactory().getServerPort();
    }

    public ContextId getClientID() throws SSLException, UnknownHostException, ClassNotFoundException, SocketException, OptionalDataException, InterruptedIOException, InvalidPasswordException, IOException, NullContextException, HException {
        return this.getConnectionFactory().getClientID();
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public Locale getLocale() {
        return this._locale.length > 0 ? this._locale[0] : null;
    }

    public void setLocale(Locale locale) {
        this._locale = new Locale[]{locale};
    }

    public Locale[] getLocales() {
        return this._locale;
    }

    public void setLocales(Locale[] locales) {
        this._locale = (Locale[])locales.clone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return TimeZone.getDefault();
    }

    public boolean isLocalContext() throws UnknownHostException {
        if (CommonSystem.getCommonSystem().isUsingHTML()) {
            if (this._address.isLoopbackAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(this._address) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        InetAddress mgrAddress = this.getServerAddress();
        InetAddress clientAddress = InetAddress.getLocalHost();
        return mgrAddress != null && (mgrAddress.equals(clientAddress) || mgrAddress.isLoopbackAddress());
    }

    public String toString() {
        return "ClientUserContext( address=" + this.getAddress() + " )";
    }
}

